; Button.asm - demonstrates button child window controls
;
; This example demonstrates how to use button controls with several styles:
;
;   Autocheckbox
;     A checkbox that toggles the flag automatically each time it's clicked
;   Checkbox
;     As auto, but the flag isn't toggled automatically
;   Defpushbutton
;     Same as a pushbutton, except it is the default button. For use
;     within a dialog box.
;   Pushbutton
;     Hmm, I wonder?
;
; I have not bothered with doing the three state checkbox as it is
; effectively just an extension to the standard checkbox. Also, I have
; left out the group box (as it is really only of use in a dialog box)
; and the radio button as this is only really of use in a dialog box.
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

ddglobal _gbl_hInstance

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	eax, .hInstance
	mov	._gbl_hInstance, eax
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Button child window controls',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_width, _height
	buffstatic	_hwndButtons, 4*8
	endlocals
	;
	CallbackPrologue
	;
	switch .message
		case WM_CREATE
			;
			; Create two child windows for each control. One window
			; will be for the actual control, and one will be for us to do
			; some output on.
			;
			; Auto checkbox
			;
			mov	esi, ._hwndButtons
			TEXTlocal _szAutocheckbox, 'Autocheckbox',0
			sc CreateWindowEx, 0, _szClassNameButton, ._szAutocheckbox, WS_CHILDWINDOW | WS_VISIBLE | BS_AUTOCHECKBOX, 0, 0, 0, 0, .hwnd, 1, ._gbl_hInstance, NULL
			mov	[esi], eax
			sc CreateWindowEx, 0, _szClassNameStatic, NULL, WS_CHILDWINDOW | WS_VISIBLE | SS_CENTER, 0, 0, 0, 0, .hwnd, 2, ._gbl_hInstance, NULL
			mov	[esi + 4], eax
			;
			; Checkbox
			;
			TEXTlocal _szCheckbox, 'Checkbox',0
			sc CreateWindowEx, 0, _szClassNameButton, ._szCheckbox, WS_CHILDWINDOW | WS_VISIBLE | BS_CHECKBOX, 0, 0, 0, 0, .hwnd, 3, ._gbl_hInstance, NULL
			mov	[esi + 8], eax
			sc CreateWindowEx, 0, _szClassNameStatic, NULL, WS_CHILDWINDOW | WS_VISIBLE | SS_CENTER, 0, 0, 0, 0, .hwnd, 4, ._gbl_hInstance, NULL
			mov	[esi + 12], eax
			;
			; Def push button
			;
			TEXTlocal _szDefPushbutton, 'Defpushbutton',0
			sc CreateWindowEx, 0, _szClassNameButton, ._szDefPushbutton, WS_CHILDWINDOW | WS_VISIBLE | BS_DEFPUSHBUTTON, 0, 0, 0, 0, .hwnd, 5, ._gbl_hInstance, NULL
			mov	[esi + 16], eax
			sc CreateWindowEx, 0, _szClassNameStatic, NULL, WS_CHILDWINDOW | WS_VISIBLE | SS_CENTER, 0, 0, 0, 0, .hwnd, 6, ._gbl_hInstance, NULL
			mov	[esi + 20], eax
			;
			; Push button
			;
			TEXTlocal _szPushbutton, 'Pushbutton',0
			sc CreateWindowEx, 0, _szClassNameButton, ._szPushbutton, WS_CHILDWINDOW | WS_VISIBLE | BS_PUSHBUTTON, 0, 0, 0, 0, .hwnd, 7, ._gbl_hInstance, NULL
			mov	[esi + 24], eax
			sc CreateWindowEx, 0, _szClassNameStatic, NULL, WS_CHILDWINDOW | WS_VISIBLE | SS_CENTER, 0, 0, 0, 0, .hwnd, 8, ._gbl_hInstance, NULL
			mov	[esi + 28], eax
			;
			; End initialisation
			;
			xor	eax, eax
			break
		case WM_COMMAND
			;
			; Get the child window handle in ebx
			;
			mov	ebx, .lParam
			;
			; esi -> handle array
			;
			mov	esi, ._hwndButtons
			switch ebx
				case [esi]
					;
					; Child one - autocheckbox
					;
					; With autocheckboxes, Windows checks and unchecks the box
					; automatically so you can effectively ignore WM_COMMAND
					; messages from it, unless another part of the window or
					; dialog depends on its value. If you need to get the current
					; state, you can do this by sending a message to it:
					;
					sc SendMessage, [esi], BM_GETCHECK, 0, 0
					;
					; BM_GETCHECK, unsurprisingly, returns the checkbox state:
					;   BST_UNCHECKED means it's unchecked
					;   BST_CHECKED means it's checked
					;   BST_INDETERMINATE means it's grayed (in a 3-state box)
					;
					; In this example, we output a string to the window next to
					; the child window control stating what's happened. We
					; assume it's checked to start with
					;
					TEXTlocal _szAutoChecked, 'Checked', 0
					TEXTlocal _szAutoUnchecked, 'Unchecked',0
					mov	ecx, ._szAutoChecked
					;
					; Is it really checked?
					;
					if eax, ne, BST_CHECKED
						;
						; No, so use the unchecked message
						;
						mov	ecx, ._szAutoUnchecked
					endif
					;
					; Finally call SetWindowText to display the message
					;
					sc SetWindowText, [esi + 4], ecx
					xor	eax, eax
					break
				case [esi + 8]
					;
					; Child two - checkbox
					;
					; Unlike autocheckboxes, we have to check and uncheck the
					; control ourselves. First thing to do is get the current
					; state:
					;
					sc SendMessage, [esi + 8], BM_GETCHECK, 0, 0
					;
					; Now assume the control is unchecked, ie we want to make
					; it checked and display the 'Checked' string. To check
					; the control we send it a BM_SETCHECK message with a
					; parameter denoting the new check state.
					;
					TEXTlocal _szChecked, 'Checked', 0
					TEXTlocal _szUnchecked, 'Unchecked',0
					mov	edi, ._szChecked	; use edi as it's preserved across API calls
					mov	edx, BST_CHECKED	; edx won't matter
					;
					; Is the control unchecked (ie we'll make it checked)?
					;
					if eax, ne, BST_UNCHECKED
						;
						; No, so use the unchecked string and message parameter
						;
						mov	edi, ._szUnchecked
						mov	edx, BST_UNCHECKED
					endif
					;
					; Call SendMessage to set the check state, and then
					; SetWindowText to display the message
					;
					sc SendMessage, [esi + 8], BM_SETCHECK, edx, 0
					sc SetWindowText, [esi + 12], edi
					xor	eax, eax
					break
				case [esi + 16]
					;
					; Child three - defpushbutton
					;
					; For this example, we'll disable the child control and
					; output some text in the window. We can do this by the
					; EnableWindow function which takes two parameters:
					;
					;   1. Window handle
					;   2. Boolean for whether to enable or disable it
					;
					sc EnableWindow, [esi + 16], FALSE
					TEXTlocal _szDefClicked, 'Clicked',0
					sc SetWindowText, [esi + 20], ._szDefClicked
					xor	eax, eax
					break
				case [esi + 24]
					;
					; Child four - pushbutton
					;
					; Just do the same as we did for child 3 (because I can't
					; think of anything else to do right now)
					;
					sc EnableWindow, [esi + 24], FALSE
					TEXTlocal _szClicked, 'Clicked',0
					sc SetWindowText, [esi + 28], ._szClicked
					xor	eax, eax
					break
			switchend
			break
		case WM_SIZE
			;
			; Resize the window - we obtain the window width and height in esi
			; and edi and then split it into 8 windows for the controls, with
			; four down and two across
			;
			mov	ebx, .lParam
			movsx	esi, bx
			shr	ebx, 16
			movsx	edi, bx
			;
			; Divide width by 2
			;
			shr	esi, 1
			;
			; Divide height by four
			;
			shr	edi, 2
			;
			; Save the width and height
			;
			mov	._width, esi
			mov	._height, edi
			mov	esi, ._hwndButtons
			;
			; Now create the windows. The size is always width=esi and height=edi,
			; only the vertical position changes each time
			;
			sc MoveWindow, [esi], 0, 0, ._width, ._height, TRUE
			sc MoveWindow, [esi + 4], ._width, 0, ._width, ._height, TRUE
			;
			; The second window is one window down, ie ._height
			;
			sc MoveWindow, [esi + 8], 0, edi, ._width, ._height, TRUE
			sc MoveWindow, [esi + 12], ._width, edi, ._width, ._height, TRUE
			;
			; The third is two down, ie ._height times 2
			;
			shl	edi, 1
			sc MoveWindow, [esi + 16], 0, edi, ._width, ._height, TRUE
			sc MoveWindow, [esi + 20], ._width, edi, ._width, ._height, TRUE
			;
			; The fourth is three down, ie ._height times 3
			;
			add	edi, ._height
			sc MoveWindow, [esi + 24], 0, edi, ._width, ._height, TRUE
			sc MoveWindow, [esi + 28], ._width, edi, ._width, ._height, TRUE
			;
			; And end the initialisation
			;
			xor	eax, eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax, eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	;
	CallbackEpilogue
endproc
;
;-----------------------------------------------------------------------
;
[section .bss]

[section .data]
